var BAUD_RATE = 9600;
var DELIMITER = ',';
var SENSOR_NUMBER = 14;
var NEWLINE = "\n";

var connectionId = -1;
var readBuffer = '';

function onOpen(openInfo) {
  connectionId = openInfo.connectionId;
  if (connectionId == -1) {
    setStatus('Could not connect to serial device.');
  } else {
    chrome.serial.read(connectionId, 1, onRead);
    setStatus('Connected to serial device.');
  }
}

function onRead(readInfo) {
  var value = readNextCharacter(readInfo);
  if (value != NEWLINE) {
    readBuffer += value;
  } else {
    processReadBuffer();
    readBuffer = '';
  }
  chrome.serial.read(connectionId, 1, onRead);
}

function processReadBuffer() {
  var attr = readBuffer.split(DELIMITER);
  if (attr.length == SENSOR_NUMBER) {
    setRawData(readBuffer);
    var intAttr = attr.map(function(x) { return parseInt(x); });
    document.getElementById('slider').value = 1023 - intAttr[4];
  }
}

function readNextCharacter(readInfo) {
  var uint8View = new Uint8Array(readInfo.data);
  return String.fromCharCode(uint8View[0]);
}

function setStatus(status) {
  document.getElementById('status').innerText = status;
}

function setRawData(rawData) {
  document.getElementById('raw-data').innerText = rawData;
}

function buildPortPicker(ports) {
  var eligiblePorts = getEligiblePorts(ports);
  var portPicker = populatePortPicker(eligiblePorts);
  portPicker.onchange = portChangedEvent;
}

function portChangedEvent() {
  if (connectionId != -1) {
    chrome.serial.close(connectionId, BAUD_RATE, openSelectedPort);
    setStatus('Loading...');
  }
  openSelectedPort(); 
}

function populatePortPicker(eligiblePorts) {
  var portPicker = document.getElementById('port-picker');
  eligiblePorts.forEach(function(port) {
    var portOption = document.createElement('option');
    portOption.value = portOption.innerText = port;
    portPicker.appendChild(portOption);
  });
  return portPicker;
}

function getEligiblePorts(ports) {
  var eligiblePorts = ports.filter(function(port) {
    return !port.match(/[Bb]luetooth/);
  });
  return eligiblePorts;
}

function openSelectedPort() {
  var portPicker = document.getElementById('port-picker');
  var selectedPort = portPicker.options[portPicker.selectedIndex].value;
  chrome.serial.open(selectedPort, onOpen);
}

function stringToArrayBuffer(str) {
  var buffer = new ArrayBuffer(str.length);
  var bufferView = new Uint8Array(buffer);
  for (var i = 0; i < str.length; i++) {
    bufferView[i] = str.charCodeAt(i);
  }
  return buffer;
}

function sendCommand(data) {
  chrome.serial.write(connectionId, stringToArrayBuffer(data), function() {});
}

function setLed(color) {
  sendCommand('R' + parseInt(color.substring(1, 3), 16));
  sendCommand('G' + parseInt(color.substring(3, 5), 16));
  sendCommand('B' + parseInt(color.substring(5, 7), 16));
}

function setTone(frequency) {
  sendCommand('T' + parseInt(frequency));
}

onload = function() {
  document.getElementById('rgbled').onchange = function() {    
    setLed(this.value);
    console.log('Setting LED color to ' + this.value + '.');
  };

  document.getElementById('frequency').onchange = function() {    
    setTone(this.value);
    console.log('Setting frequency to ' + this.value + '.');
  };

  chrome.serial.getPorts(function(ports) {
    buildPortPicker(ports)
    openSelectedPort();
  });
};
